---
title: Codeformer API Usage Guide
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# Codeformer API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the Codeformer API, is a deep learning model designed primarily for image restoration tasks, particularly for enhancing the quality of low-resolution, degraded, or old images. It is known for its ability to perform face restoration, making it especially useful for tasks such as upscaling low-resolution faces in images or videos

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
    "image": "https://replicate.delivery/mgxm/7534e8f1-ee01-4d66-ae40-36343e5eb44a/003.png",
    "upscale": 2,
    "face_upsample": true,
    "background_enhance": true,
    "codeformer_fidelity": 0.1
  }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/codeformer@lucataco", data, price);
    // Handle response
    console.log("Codeformer result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `image`: String, Please provide the image file that needs to be processed.
- `upscale`: String, The final upsampling scale of the image.
- `face_upsample`: String, Upsample restored faces for high-resolution AI-created images.
- `background_enhance`: Boolean, Enhance background image with Real-ESRGAN.
- `codeformer_fidelity`: Boolean, Balance the quality (lower number) and fidelity (higher number).

### Notes

- Ensure that the provided image URL is publicly accessible and of good quality to achieve the best recognition results.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and privacy regulations, especially when handling image samples of others.

### Example Response

The API response will contain the results of the image recognition or other relevant information. Parse and use the response data according to the actual API documentation.

